export async function isAdminAuthed(): Promise<boolean> {
  // Check if we have a stored admin token
  if (sessionStorage.getItem("adminToken")) {
    return true;
  }
  
  // Check if user is signed in with admin privileges
  try {
    const { auth } = await import('@/lib/firebase');
    const user = auth.currentUser;
    
    if (user) {
      const tokenResult = await user.getIdTokenResult();
      if (tokenResult.claims.admin) {
        // Automatically set admin token from Firebase
        const token = await user.getIdToken();
        sessionStorage.setItem("adminToken", token);
        return true;
      }
    }
  } catch (error) {
    console.error('Error checking Firebase admin status:', error);
  }
  
  return false;
}

export async function requireAdminOrRedirect(): Promise<string | null> {
  // First check if we already have admin access
  const isAuthed = await isAdminAuthed();
  if (isAuthed) {
    return sessionStorage.getItem("adminToken");
  }
  
  // If not authed, redirect to login
  window.location.replace("/admin/login");
  return null;
}

// New function to set admin token from regular Firebase token
export async function setAdminTokenFromFirebase(): Promise<string | null> {
  try {
    // Get Firebase auth from the regular app
    const { auth } = await import('@/lib/firebase');
    const user = auth.currentUser;
    
    if (!user) return null;
    
    // Check if user has admin claim
    const tokenResult = await user.getIdTokenResult();
    if (tokenResult.claims.admin) {
      const token = await user.getIdToken();
      sessionStorage.setItem("adminToken", token);
      return token;
    }
  } catch (error) {
    console.error('Failed to set admin token from Firebase:', error);
  }
  return null;
}

export function adminSignOut() {
  sessionStorage.removeItem("adminToken");
  window.location.replace("/admin/login");
}