Alright, King — let’s implement exactly what you asked:

Replace “Browse Marketplace + Search Assets” with:

Browse Marketplace (everyone can see — public shop)

My Marketplace (only for Creators/Admin/Owner — creator’s own catalog)

Move the old “Search Assets” function to Admin Dashboard later (not in sidebar).

Fix the sidebar highlight by using route-based state (no more ?search=true race).

Add a new My Marketplace page where creators can:

See all their active listings

Cancel a listing (moves to “Cancelled Assets” section)

Upload new assets

See payouts + performance stats

Below are full, drop-in file replacements + one new file. I kept names/paths consistent with your app. Citations to the files you provided are included for traceability:

1) client/src/components/Sidebar.tsx (full file — replace)
import React, { useState, useEffect } from 'react';
import { useLocation, Link } from 'wouter';
import { useAuth } from '@/contexts/AuthContext';
import { featureFlags } from '@/lib/featureFlags';
import {
  BarChart3,
  Lightbulb,
  MessageSquare,
  FileText,
  Share2,
  Globe,
  Link as LinkIcon,
  Server,
  LogOut,
  Briefcase,
  ChevronDown,
  ChevronRight,
  Layers,
  Presentation,
  GalleryVerticalEnd,
  CaseSensitive,
  Image,
  Boxes,
  Images,
  PieChart,
  Library,
  ShoppingBag,
  Store,
  User
} from 'lucide-react';
import { useLogo } from '@/hooks/useLogo';
import { bulletCubeBlack, bulletCubeWhite } from '@/assets';

const dashboardItem = {
  id: 'dashboard',
  name: 'Dashboard',
  icon: BarChart3,
  path: '/dashboard',
  enabled: true
};

const businessDevelopmentItems = [
  { id: 'business-name', name: 'Business Name Wizard', icon: Lightbulb, path: '/name-wizard', enabled: true },
  { id: 'domains', name: 'Find a Domain', icon: LinkIcon, path: '/domains', enabled: true },
  { id: 'slogan-generator', name: 'Slogan Generator', icon: MessageSquare, path: '/slogans', enabled: featureFlags.sloganGenerator },
  {
    id: 'brand-kit',
    name: 'Brand Kit Generator',
    icon: (isActive: any = false) => {
      const actualIsActive = typeof isActive === 'object' ? isActive?.isActive : isActive;
      return <img src={actualIsActive ? bulletCubeWhite : bulletCubeBlack} alt="Brand Kit" className="w-5 h-5 relative -ml-0.5 mr-3" />;
    },
    path: '/brand-kit',
    enabled: true
  },
  { id: 'business-plan', name: 'Business Plan Generator', icon: FileText, path: '/plan', enabled: featureFlags.businessPlan },
  // Phase 2 placeholders
  { id: 'website-templates', name: 'Website Templates', icon: Globe, path: '/website-templates', enabled: false },
  { id: 'hosting', name: 'Web Hosting', icon: Server, path: '/hosting', enabled: false },
  { id: 'social-media', name: 'Social Media Kits', icon: Share2, path: '/social-kits', enabled: false },
];

const businessAssetsItems = [
  // Templates
  { id: 'cover-divider-templates', name: 'Cover & Divider Templates', icon: Presentation, path: '/business-assets/templates/cover-dividers', enabled: true, group: 'Templates' },
  { id: 'presentation-template', name: 'Presentation Templates', icon: Presentation, path: '/business-assets/templates/presentation-template', enabled: true, group: 'Templates' },
  { id: 'business-plan-template', name: 'Business Plan Template', icon: GalleryVerticalEnd, path: '/business-assets/templates/business-plan', enabled: true, group: 'Templates' },
  { id: 'logo-templates', name: 'Logo Templates', icon: CaseSensitive, path: '/business-assets/templates/logo-templates', enabled: true, group: 'Templates' },
  // Digital Assets
  { id: 'infographic-library', name: 'Infographic Library', icon: PieChart, path: '/infographic-library', enabled: true, group: 'Digital Assets' },
];

const stockLibraryItems = [
  { id: 'icons', name: 'Icons Library', icon: Image, path: '/business-assets/stock/icons', enabled: true },
  { id: 'mockups', name: 'Mockups Library', icon: Boxes, path: '/business-assets/stock/mockups', enabled: true },
  { id: 'stock-photos', name: 'Stock Photos', icon: Images, path: '/business-assets/stock/photos', enabled: true },
];

export function Sidebar() {
  const [location, setLocation] = useLocation();
  const { currentUser, logout } = useAuth();
  const [backendUser, setBackendUser] = useState<any>(null);
  const [isBusinessDevOpen, setIsBusinessDevOpen] = useState(true);
  const [isBusinessAssetsOpen, setIsBusinessAssetsOpen] = useState(true);
  const [isStockLibraryOpen, setIsStockLibraryOpen] = useState(true);
  const [isDigitalAssetsOpen, setIsDigitalAssetsOpen] = useState(true);
  const [isMarketplaceOpen, setIsMarketplaceOpen] = useState(true);
  const logoPath = useLogo();

  // role helpers
  const isAdminLike = (u: any) => {
    const r = (u?.role || u?.roles || []).toString().toLowerCase();
    return r.includes('admin') || r.includes('owner') || r.includes('manager');
  };
  const isCreator = (u: any) => {
    const r = (u?.role || u?.roles || []).toString().toLowerCase();
    return r.includes('creator') || isAdminLike(u);
  };

  // Fetch backend user (who am I + roles)
  useEffect(() => {
    const fetchBackendUser = async () => {
      if (!currentUser) { setBackendUser(null); return; }
      try {
        const token = await currentUser.getIdToken();
        const res = await fetch('/api/auth/me', { headers: { Authorization: `Bearer ${token}` } });
        if (res.ok) setBackendUser(await res.json());
      } catch (e) {
        console.error('Failed to fetch backend user profile:', e);
      }
    };
    fetchBackendUser();
  }, [currentUser]);

  const handleLogout = async () => {
    try { await logout(); } catch (e) { console.error('Failed to log out:', e); }
  };

  const getInitials = (name: string) => name.split(' ').map(n => n[0]).join('').toUpperCase();

  return (
    <div className="w-[17.85rem] flex-shrink-0 bg-card border-r border-border shadow-lg">
      <div className="flex flex-col h-full overflow-y-auto">
        {/* Logo */}
        <div className="flex items-center px-6 py-4 border-b border-border">
          <Link href="/">
            <div className="flex items-center cursor-pointer" data-testid="link-logo-sidebar">
              <img src={logoPath} alt="IBrandBiz" className="h-[4.2rem] w-auto" />
            </div>
          </Link>
        </div>

        {/* Navigation */}
        <nav className="flex-1 px-4 py-6 space-y-2">
          {/* Dashboard */}
          {dashboardItem.enabled && (
            <button
              key={dashboardItem.id}
              onClick={() => setLocation(dashboardItem.path)}
              className={`w-full flex items-center px-3 py-2 rounded-lg text-lg font-bold transition-colors ${
                location === dashboardItem.path ? 'bg-primary text-white' : 'text-muted-foreground hover:bg-lightgray hover:text-foreground'
              }`}
              data-testid={`nav-${dashboardItem.id}`}
            >
              <BarChart3 className="mr-3 h-4 w-4" />
              {dashboardItem.name}
            </button>
          )}

          {/* Business Development */}
          <div className="space-y-1">
            <button
              onClick={() => setIsBusinessDevOpen(!isBusinessDevOpen)}
              className="w-full flex items-center px-3 py-2 rounded-lg text-sm font-medium text-muted-foreground hover:bg-lightgray hover:text-foreground transition-colors"
              data-testid="nav-business-development"
            >
              <Briefcase className="mr-3 h-4 w-4" />
              Business Development
              {isBusinessDevOpen ? <ChevronDown className="ml-auto h-4 w-4" /> : <ChevronRight className="ml-auto h-4 w-4" />}
            </button>

            {isBusinessDevOpen && (
              <div className="ml-6 space-y-1">
                {businessDevelopmentItems.filter(i => i.enabled).map((item) => {
                  const Icon = item.icon as any;
                  const isActive = location === item.path;
                  return (
                    <button
                      key={item.id}
                      onClick={() => setLocation(item.path)}
                      className={`w-full flex items-center px-3 py-2 rounded-lg text-sm font-medium transition-colors ${
                        isActive ? 'bg-primary text-white font-bold' : 'text-muted-foreground hover:bg-lightgray hover:text-foreground'
                      }`}
                      data-testid={`nav-${item.id}`}
                    >
                      {item.id === 'brand-kit' ? <Icon isActive={isActive} /> : <Icon className="mr-3 h-4 w-4" />}
                      {item.name}
                    </button>
                  );
                })}
              </div>
            )}
          </div>

          {/* Business Assets */}
          <div className="space-y-1">
            <button
              onClick={() => setIsBusinessAssetsOpen(!isBusinessAssetsOpen)}
              className="w-full flex items-center px-3 py-2 rounded-lg text-sm font-medium text-muted-foreground hover:bg-lightgray hover:text-foreground transition-colors"
              data-testid="nav-business-assets"
            >
              <Layers className="mr-3 h-4 w-4" />
              Business Assets
              {isBusinessAssetsOpen ? <ChevronDown className="ml-auto h-4 w-4" /> : <ChevronRight className="ml-auto h-4 w-4" />}
            </button>

            {isBusinessAssetsOpen && (
              <div className="ml-6 space-y-1">
                {/* Templates header */}
                <div className="px-3 pt-2 pb-1 text-xs uppercase tracking-wide text-muted-foreground font-medium">Templates</div>
                {businessAssetsItems.filter(i => i.enabled && i.group === 'Templates').map((item) => {
                  const Icon = item.icon; const isActive = location === item.path;
                  return (
                    <button
                      key={item.id}
                      onClick={() => setLocation(item.path)}
                      className={`w-full flex items-center px-3 py-2 rounded-lg text-sm font-medium transition-colors ${
                        isActive ? 'bg-primary text-white font-bold' : 'text-muted-foreground hover:bg-lightgray hover:text-foreground'
                      }`}
                      data-testid={`nav-${item.id}`}
                    >
                      <Icon className="mr-3 h-4 w-4" />
                      {item.name}
                    </button>
                  );
                })}

                {/* Digital Assets collapse */}
                <div className="pt-2">
                  <button
                    onClick={() => setIsDigitalAssetsOpen(!isDigitalAssetsOpen)}
                    className="w-full flex items-center px-3 py-2 rounded-lg text-xs uppercase tracking-wide text-muted-foreground font-medium hover:bg-lightgray hover:text-foreground transition-colors"
                    data-testid="nav-digital-assets"
                  >
                    Digital Assets
                    {isDigitalAssetsOpen ? <ChevronDown className="ml-auto h-3 w-3" /> : <ChevronRight className="ml-auto h-3 w-3" />}
                  </button>
                  {isDigitalAssetsOpen && (
                    <div className="ml-4 space-y-1 mt-1">
                      {businessAssetsItems.filter(i => i.enabled && i.group === 'Digital Assets').map((item) => {
                        const Icon = item.icon; const isActive = location === item.path;
                        return (
                          <button
                            key={item.id}
                            onClick={() => setLocation(item.path)}
                            className={`w-full flex items-center px-3 py-2 rounded-lg text-sm font-medium transition-colors ${
                              isActive ? 'bg-primary text-white font-bold' : 'text-muted-foreground hover:bg-lightgray hover:text-foreground'
                            }`}
                            data-testid={`nav-${item.id}`}
                          >
                            <Icon className="mr-3 h-4 w-4" />
                            {item.name}
                          </button>
                        );
                      })}
                    </div>
                  )}
                </div>
              </div>
            )}
          </div>

          {/* Stock Library */}
          <div className="space-y-1">
            <button
              onClick={() => setIsStockLibraryOpen(!isStockLibraryOpen)}
              className="w-full flex items-center px-3 py-2 rounded-lg text-sm font-medium text-muted-foreground hover:bg-lightgray hover:text-foreground transition-colors"
              data-testid="nav-stock-library"
            >
              <Library className="mr-3 h-4 w-4" />
              Stock Library
              {isStockLibraryOpen ? <ChevronDown className="ml-auto h-4 w-4" /> : <ChevronRight className="ml-auto h-4 w-4" />}
            </button>

            {isStockLibraryOpen && (
              <div className="ml-6 space-y-1">
                {stockLibraryItems.filter(i => i.enabled).map((item) => {
                  const Icon = item.icon; const isActive = location === item.path;
                  return (
                    <button
                      key={item.id}
                      onClick={() => setLocation(item.path)}
                      className={`w-full flex items-center px-3 py-2 rounded-lg text-sm font-medium transition-colors ${
                        isActive ? 'bg-primary text-white font-bold' : 'text-muted-foreground hover:bg-lightgray hover:text-foreground'
                      }`}
                      data-testid={`nav-${item.id}`}
                    >
                      <Icon className="mr-3 h-4 w-4" />
                      {item.name}
                    </button>
                  );
                })}
              </div>
            )}
          </div>

          {/* Creator Marketplace */}
          <div className="space-y-1">
            <button
              onClick={() => setIsMarketplaceOpen(!isMarketplaceOpen)}
              className="w-full flex items-center px-3 py-2 rounded-lg text-sm font-medium text-muted-foreground hover:bg-lightgray hover:text-foreground transition-colors"
              data-testid="nav-marketplace"
            >
              <ShoppingBag className="mr-3 h-4 w-4" />
              Creator Marketplace
              {isMarketplaceOpen ? <ChevronDown className="ml-auto h-4 w-4" /> : <ChevronRight className="ml-auto h-4 w-4" />}
            </button>

            {isMarketplaceOpen && (
              <div className="ml-6 space-y-1">
                {/* Public browse (everyone) */}
                <button
                  key="marketplace-browse"
                  onClick={() => setLocation('/marketplace')}
                  className={`w-full flex items-center px-3 py-2 rounded-lg text-sm font-medium transition-colors ${
                    location.startsWith('/marketplace') && !location.startsWith('/creator/my-marketplace')
                      ? 'bg-primary text-white font-bold'
                      : 'text-muted-foreground hover:bg-lightgray hover:text-foreground'
                  }`}
                  data-testid="nav-marketplace-browse"
                >
                  <Store className="mr-3 h-4 w-4" />
                  Browse Marketplace
                </button>

                {/* Creator-only self area */}
                {isCreator(backendUser) && (
                  <button
                    key="marketplace-mine"
                    onClick={() => setLocation('/creator/my-marketplace')}
                    className={`w-full flex items-center px-3 py-2 rounded-lg text-sm font-medium transition-colors ${
                      location.startsWith('/creator/my-marketplace')
                        ? 'bg-primary text-white font-bold'
                        : 'text-muted-foreground hover:bg-lightgray hover:text-foreground'
                    }`}
                    data-testid="nav-my-marketplace"
                  >
                    <User className="mr-3 h-4 w-4" />
                    My Marketplace
                  </button>
                )}
                {/* Note: old "Search Assets" removed from sidebar; it’ll live in Admin UI */}
              </div>
            )}
          </div>
        </nav>

        {/* User Menu */}
        <div className="px-4 py-4 border-t border-border">
          <div className="flex items-center">
            <button
              onClick={() => setLocation('/profile')}
              className="flex-1 flex items-center p-2 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-800 transition-colors"
              data-testid="button-profile"
            >
              <div className="w-8 h-8 bg-accent rounded-full flex items-center justify-center mr-3">
                <span className="text-accent-foreground text-sm font-medium">
                  {(backendUser?.displayName || currentUser?.displayName) ? getInitials(backendUser?.displayName || currentUser?.displayName) : 'U'}
                </span>
              </div>
              <div className="flex-1 text-left">
                <p className="text-sm font-medium text-foreground" data-testid="text-username">
                  {backendUser?.displayName || currentUser?.displayName || 'User'}
                </p>
                <p className="text-xs text-muted-foreground" data-testid="text-email">
                  {backendUser?.email || currentUser?.email}
                </p>
              </div>
            </button>
            <button
              onClick={handleLogout}
              className="text-muted-foreground hover:text-foreground p-2 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-800 transition-colors"
              data-testid="button-logout"
              title="Log out"
            >
              <LogOut className="h-4 w-4" />
            </button>
          </div>
        </div>
      </div>
    </div>
  );
}


(We removed local “activeMarketplaceItem” + the ?search=true pathway and use URL-only for highlight. We also added My Marketplace role-gated item. Based on your current Sidebar structure. )