2) client/src/App.tsx (full file — replace)

Adds a new route: /creator/my-marketplace (protected, inside dashboard frame).

Keeps the public /marketplace browse route.

No special search route — we’re going route-based, not ?search=true.

import React, { Suspense } from "react";
import { Route, Switch } from "wouter";
import { queryClient } from "./lib/queryClient";
import { QueryClientProvider } from "@tanstack/react-query";
import { Toaster } from "@/components/ui/toaster";
import { Toaster as SonnerToaster } from "sonner";
import { TooltipProvider } from "@/components/ui/tooltip";
import { AuthProvider } from "@/contexts/AuthContext";
import { CartProvider } from "@/contexts/CartContext";
import { NotificationsProvider } from "@/components/NotificationsProvider";
import { ProtectedRoute } from "@/components/ProtectedRoute";
import { Sidebar } from "@/components/Sidebar";
import { TopBar } from "@/components/TopBar";
import { DashboardTemplatePage } from "@/components/DashboardTemplatePage";
import Footer from "@/components/Footer";
import { CookieConsentBanner } from "@/components/CookieConsentBanner";
import { featureFlags } from "@/lib/featureFlags";
import Home from "@/pages/Home";
import About from "@/pages/About";
import ServicesPage from "@/pages/Services";
import Products from "@/pages/Products";
import Terms from "@/pages/Terms";
import Privacy from "@/pages/Privacy";
import Cookies from "@/pages/Cookies";
import Dashboard from "@/pages/Dashboard";
import BrandKit from "@/pages/BrandKit";
import BusinessName from "@/pages/BusinessName";
import SloganPage from "@/pages/SloganPage";
import BusinessPlanBuilder from "@/pages/BusinessPlanBuilder";
import BuilderV7 from "@/pages/Builder.v7";
import DomainsPage from "@/pages/DomainsPage";
import DomainOrderStatusPage from "@/pages/DomainOrderStatusPage";
import SocialMedia from "@/pages/SocialMedia";
import WebsiteTemplates from "@/pages/WebsiteTemplates";
import Hosting from "@/pages/Hosting";
import WebHosting from "@/pages/WebHosting";
import StockImages from "@/pages/StockImages";
import BrandAssets from "@/pages/BrandAssets";
import PricingPage from "@/pages/PricingPage";
import ResourcesPage from "@/pages/Resources/ResourcesPage";
import FAQPage from "@/pages/FAQPage";
import SettingsPage from "@/pages/Settings/SettingsPage";
import SignupPage from "@/pages/SignupPage";
import AdminHome from "@/pages/Admin/AdminHome";
import AdminLogin from "@/pages/Admin/AdminLogin";
import AdminDashboard from "@/pages/Admin/AdminDashboard";
import AdminAssetsReview from "@/pages/Admin/AdminAssetsReview";
import StockUploader from "@/pages/Admin/StockUploader";
import StockManager from "@/pages/Admin/StockManager";
import IconsManager from "@/pages/Admin/IconsManager";

// Lazy
const IconImporter = React.lazy(() => import("@/pages/Admin/IconImporter"));
const IconLabeler = React.lazy(() => import("@/pages/Admin/IconLabeler"));
const StockPhotos = React.lazy(() => import("@/pages/business-assets/stock/StockPhotos"));
const Mockups = React.lazy(() => import("@/pages/business-assets/stock/Mockups"));

import ProfilePage from "@/pages/Profile/ProfilePage";
import NotFound from "@/pages/not-found";

// Creator Marketplace pages
import CreatorDashboard from "@/pages/Creator/CreatorDashboard";
import CreatorOnboarding from "@/pages/Creator/CreatorOnboarding";
import CreatorUpload from "@/pages/Creator/CreatorUpload";
import CreatorAssets from "@/pages/Creator/CreatorAssets";
import CreatorEarnings from "@/pages/Creator/CreatorEarnings";
import MyMarketplacePage from "@/pages/Creator/MyMarketplacePage"; // NEW

// Public marketplace
import MarketplacePage from "@/pages/MarketplacePage";
import AssetDetailPage from "@/pages/AssetDetailPage";
import CreatorProfilePage from "@/pages/CreatorProfilePage";

// Business Assets
import CoverDividerTemplates from "@/pages/business-assets/templates/CoverDividerTemplates";
import PresentationTemplate from "@/pages/business-assets/templates/PresentationTemplate";
import BusinessPlanTemplate from "@/pages/business-assets/templates/BusinessPlanTemplate";
import LogoTemplates from "@/pages/business-assets/templates/LogoTemplates";
import IconsPage from "@/pages/business-assets/stock/Icons";
import InfographicsLibrary from "@/pages/InfographicsLibrary";

function CookieRedirect() {
  window.location.href = "/cookie-policy";
  return null;
}

function AppLayout({ children, title }: { children: React.ReactNode; title: string }) {
  return (
    <div className="min-h-screen bg-background flex flex-col">
      <div className="flex flex-1 min-h-0 items-stretch">
        <Sidebar />
        <div className="flex-1 min-w-0">
          <TopBar title={title} />
          <main className="p-6">{children}</main>
        </div>
      </div>
      <Footer />
    </div>
  );
}

function Router() {
  return (
    <Switch>
      {/* Public */}
      <Route path="/"><Home /></Route>
      <Route path="/about"><About /></Route>
      <Route path="/services"><ServicesPage /></Route>
      <Route path="/products"><Products /></Route>
      <Route path="/terms"><Terms /></Route>
      <Route path="/privacy"><Privacy /></Route>
      <Route path="/cookie-policy"><Cookies /></Route>
      <Route path="/cookies"><Cookies /></Route>
      <Route path="/pricing"><PricingPage /></Route>
      <Route path="/signup"><SignupPage /></Route>
      <Route path="/resources"><ResourcesPage /></Route>
      <Route path="/faq"><FAQPage /></Route>
      <Route path="/web-hosting"><WebHosting /></Route>
      <Route path="/stock-images">
        <ProtectedRoute>
          <Suspense fallback={<div className="flex items-center justify-center h-64"><div className="animate-spin h-8 w-8 border-2 border-primary border-t-transparent rounded-full"></div></div>}>
            <StockPhotos />
          </Suspense>
        </ProtectedRoute>
      </Route>
      <Route path="/brand-assets"><BrandAssets /></Route>

      {/* Public Marketplace */}
      <Route path="/marketplace">
        <AppLayout title="Creator Marketplace">
          <MarketplacePage />
        </AppLayout>
      </Route>
      <Route path="/marketplace/asset/:id">
        <AppLayout title="Asset Details">
          <AssetDetailPage />
        </AppLayout>
      </Route>
      <Route path="/marketplace/creator/:id">
        <AppLayout title="Creator Profile">
          <CreatorProfilePage />
        </AppLayout>
      </Route>

      {/* Admin */}
      <Route path="/admin"><AdminHome /></Route>
      <Route path="/admin/login"><AdminLogin /></Route>
      <Route path="/admin/dashboard"><AdminDashboard /></Route>
      <Route path="/admin/assets"><AdminAssetsReview /></Route>
      <Route path="/admin/icon-importer">
        <Suspense fallback={<div className="flex items-center justify-center h-64"><div className="animate-spin h-8 w-8 border-2 border-primary border-t-transparent rounded-full"></div></div>}>
          <IconImporter />
        </Suspense>
      </Route>
      <Route path="/admin/stock-uploader"><StockUploader /></Route>
      <Route path="/admin/stock-manager"><StockManager /></Route>
      <Route path="/admin/icons-manager"><IconsManager /></Route>

      {/* Settings */}
      <Route path="/settings">
        <ProtectedRoute>
          <DashboardTemplatePage title="Settings">
            <SettingsPage />
          </DashboardTemplatePage>
        </ProtectedRoute>
      </Route>

      {/* Dashboard/Profile */}
      <Route path="/dashboard">
        <ProtectedRoute>
          <AppLayout title="Dashboard"><Dashboard /></AppLayout>
        </ProtectedRoute>
      </Route>
      <Route path="/profile">
        <ProtectedRoute>
          <AppLayout title="Profile"><ProfilePage /></AppLayout>
        </ProtectedRoute>
      </Route>

      {/* App Core */}
      <Route path="/name-wizard">
        <ProtectedRoute>
          <AppLayout title="Business Name Wizard"><BusinessName /></AppLayout>
        </ProtectedRoute>
      </Route>
      <Route path="/brand-kit">
        <ProtectedRoute>
          <AppLayout title="Brand Kit Generator"><BrandKit /></AppLayout>
        </ProtectedRoute>
      </Route>
      <Route path="/brand-kits">
        <ProtectedRoute>
          <AppLayout title="Brand Kit Generator"><BrandKit /></AppLayout>
        </ProtectedRoute>
      </Route>
      <Route path="/domains">
        <ProtectedRoute>
          <AppLayout title="Domains"><DomainsPage /></AppLayout>
        </ProtectedRoute>
      </Route>
      <Route path="/domains/orders/:orderId">
        <ProtectedRoute>
          <AppLayout title="Domain Order Status"><DomainOrderStatusPage /></AppLayout>
        </ProtectedRoute>
      </Route>
      <Route path="/website-templates">
        <ProtectedRoute>
          <AppLayout title="Website Templates"><WebsiteTemplates /></AppLayout>
        </ProtectedRoute>
      </Route>
      <Route path="/social-kits">
        <ProtectedRoute>
          <AppLayout title="Social Media Kits"><SocialMedia /></AppLayout>
        </ProtectedRoute>
      </Route>
      <Route path="/social-media-kits">
        <ProtectedRoute>
          <AppLayout title="Social Media Kits"><SocialMedia /></AppLayout>
        </ProtectedRoute>
      </Route>
      <Route path="/hosting">
        <ProtectedRoute>
          <AppLayout title="Web Hosting"><Hosting /></AppLayout>
        </ProtectedRoute>
      </Route>

      {/* Feature Flags */}
      {featureFlags.sloganGenerator && (
        <Route path="/slogans">
          <ProtectedRoute>
            <AppLayout title="Slogan Generator"><SloganPage /></AppLayout>
          </ProtectedRoute>
        </Route>
      )}
      {featureFlags.businessPlan && (
        <Route path="/plan">
          <ProtectedRoute>
            <BusinessPlanBuilder />
          </ProtectedRoute>
        </Route>
      )}

      {/* Builder V7 */}
      <Route path="/builder">
        <ProtectedRoute>
          <AppLayout title="Business Plan Builder V7"><BuilderV7 /></AppLayout>
        </ProtectedRoute>
      </Route>

      {/* Business Assets */}
      <Route path="/business-assets/templates/cover-dividers">
        <ProtectedRoute><CoverDividerTemplates /></ProtectedRoute>
      </Route>
      <Route path="/business-assets/templates/presentation-template">
        <ProtectedRoute><PresentationTemplate /></ProtectedRoute>
      </Route>
      <Route path="/business-assets/templates/business-plan">
        <ProtectedRoute><BusinessPlanTemplate /></ProtectedRoute>
      </Route>
      <Route path="/business-assets/templates/logo-templates">
        <ProtectedRoute><LogoTemplates /></ProtectedRoute>
      </Route>

      {/* Creator Program */}
      <Route path="/creator/dashboard">
        <ProtectedRoute>
          <DashboardTemplatePage title="Creator Dashboard"><CreatorDashboard /></DashboardTemplatePage>
        </ProtectedRoute>
      </Route>
      <Route path="/creator/onboarding">
        <ProtectedRoute>
          <DashboardTemplatePage title="Creator Onboarding"><CreatorOnboarding /></DashboardTemplatePage>
        </ProtectedRoute>
      </Route>
      <Route path="/creator/upload">
        <ProtectedRoute>
          <DashboardTemplatePage title="Upload Asset"><CreatorUpload /></DashboardTemplatePage>
        </ProtectedRoute>
      </Route>
      <Route path="/creator/assets">
        <ProtectedRoute>
          <DashboardTemplatePage title="Manage Assets"><CreatorAssets /></DashboardTemplatePage>
        </ProtectedRoute>
      </Route>
      <Route path="/creator/earnings">
        <ProtectedRoute>
          <DashboardTemplatePage title="Creator Earnings"><CreatorEarnings /></DashboardTemplatePage>
        </ProtectedRoute>
      </Route>

      {/* NEW: My Marketplace (creator self view) */}
      <Route path="/creator/my-marketplace">
        <ProtectedRoute>
          <DashboardTemplatePage title="My Marketplace">
            <MyMarketplacePage />
          </DashboardTemplatePage>
        </ProtectedRoute>
      </Route>

      {/* Stock Library (lazy) */}
      <Route path="/business-assets/stock/icons">
        <ProtectedRoute><IconsPage /></ProtectedRoute>
      </Route>
      <Route path="/business-assets/stock/mockups">
        <ProtectedRoute>
          <Suspense fallback={<div className="flex items-center justify-center h-64"><div className="animate-spin h-8 w-8 border-2 border-primary border-t-transparent rounded-full"></div></div>}>
            <Mockups />
          </Suspense>
        </ProtectedRoute>
      </Route>
      <Route path="/business-assets/stock/photos">
        <ProtectedRoute>
          <Suspense fallback={<div className="flex items-center justify-center h-64"><div className="animate-spin h-8 w-8 border-2 border-primary border-t-transparent rounded-full"></div></div>}>
            <StockPhotos />
          </Suspense>
        </ProtectedRoute>
      </Route>

      {/* Infographics */}
      <Route path="/infographic-library">
        <ProtectedRoute><InfographicsLibrary /></ProtectedRoute>
      </Route>

      {/* Fallback */}
      <Route path="*"><NotFound /></Route>
    </Switch>
  );
}

function App() {
  return (
    <QueryClientProvider client={queryClient}>
      <TooltipProvider>
        <AuthProvider>
          <CartProvider>
            <NotificationsProvider>
              <Toaster />
              <SonnerToaster position="top-right" />
              <Router />
              <CookieConsentBanner />
            </NotificationsProvider>
          </CartProvider>
        </AuthProvider>
      </TooltipProvider>
    </QueryClientProvider>
  );
}

export default App;


(Aligns with your current router and marketplace routes while adding the new creator page. )