{include file="orderforms/{$carttpl}/includes/head.tpl" pageTitle=$LANG.cartreview}

<div class="container">
  
  <div class="page-header-section">
    <h1 class="page-title">{$LANG.revieworder}</h1>
  </div>

  {if $errormessage}
    <div class="alert alert-danger">
      <strong>Error:</strong> {$errormessage}
    </div>
  {/if}

  {if $promoaddedsuccess}
    <div class="alert alert-success">
      <strong>Success!</strong> {$LANG.promoaddedsuccess}
    </div>
  {/if}

  <div class="row">
    <div class="col-md-8">
      
      {if $cartitems == 0}
        <div class="alert alert-info text-center">
          <p>{$LANG.cartempty}</p>
          <p><a href="{$WEB_ROOT}/cart.php" class="btn btn-primary">{$LANG.continueshopping}</a></p>
        </div>
      {else}
        
        <!-- Cart Items -->
        <div class="cart-items">
          {foreach $cartitems as $item}
            <div class="cart-item">
              <div class="row">
                <div class="col-sm-7">
                  <h4 class="cart-item-title">{$item.productinfo.groupname} - {$item.productinfo.name}</h4>
                  {if $item.domain}
                    <div class="cart-item-domain">{$item.domain}</div>
                  {/if}
                  {if $item.productinfo.description}
                    <div class="cart-item-description">{$item.productinfo.description}</div>
                  {/if}
                </div>
                <div class="col-sm-3 text-right">
                  <div class="cart-item-price">{$item.pricingtext}</div>
                  {if $item.billingcycle}
                    <div class="cart-item-cycle">{$item.billingcycle}</div>
                  {/if}
                </div>
                <div class="col-sm-2 text-right">
                  <a href="{$WEB_ROOT}/cart.php?a=confproduct&i={$item.id}" class="btn btn-sm btn-default">
                    <i class="fas fa-pencil-alt"></i> {$LANG.edit}
                  </a>
                  <a href="{$WEB_ROOT}/cart.php?a=remove&r={$item.id}" class="btn btn-sm btn-danger">
                    <i class="fas fa-times"></i>
                  </a>
                </div>
              </div>
            </div>
          {/foreach}
        </div>

        <!-- Promo Code -->
        <div class="promo-code-section">
          <form method="post" action="{$WEB_ROOT}/cart.php?a=view">
            <div class="input-group">
              <input type="text" name="promocode" class="form-control" placeholder="{$LANG.orderpromocode}" value="{$promocode}">
              <span class="input-group-btn">
                <button type="submit" name="validatepromo" class="btn btn-default">
                  {$LANG.orderpromovalidate}
                </button>
              </span>
            </div>
          </form>
        </div>

        <!-- Continue Shopping -->
        <div class="continue-shopping">
          <a href="{$WEB_ROOT}/cart.php" class="btn btn-default">
            <i class="fas fa-arrow-left"></i> {$LANG.continueshopping}
          </a>
        </div>

      {/if}
    </div>

    <!-- Order Summary Sidebar -->
    <div class="col-md-4">
      {if $cartitems > 0}
        <div class="order-summary">
          <h3 class="order-summary-header">Order Summary</h3>
          
          <div class="summary-line">
            <span class="summary-label">{$LANG.ordersubtotal}</span>
            <span class="summary-value">{$subtotal}</span>
          </div>
          
          {if $discount > 0}
            <div class="summary-line">
              <span class="summary-label">{$LANG.orderdiscount} ({$discountpercent})</span>
              <span class="summary-value">-{$discount}</span>
            </div>
          {/if}
          
          {if $taxrate}
            <div class="summary-line">
              <span class="summary-label">{$taxname} ({$taxrate}%)</span>
              <span class="summary-value">{$taxtotal}</span>
            </div>
          {/if}
          
          {if $taxrate2}
            <div class="summary-line">
              <span class="summary-label">{$taxname2} ({$taxrate2}%)</span>
              <span class="summary-value">{$taxtotal2}</span>
            </div>
          {/if}
          
          <div class="summary-line summary-total">
            <span class="summary-label"><strong>{$LANG.ordertotalduetoday}</strong></span>
            <span class="summary-value"><strong>{$total}</strong></span>
          </div>
          
          <form method="post" action="{$WEB_ROOT}/cart.php?a=checkout">
            <button type="submit" class="btn btn-primary btn-block btn-lg">
              {$LANG.checkout} <i class="fas fa-arrow-right"></i>
            </button>
          </form>
        </div>
      {/if}
    </div>
  </div>

</div>

{include file="orderforms/{$carttpl}/includes/footer.tpl"}
