# IBrandBiz Order Form Preview

This is a standalone preview of the IBrandBiz order form design, built to match the WebServicesPricing layout and brand style.

## 📋 What This Is

A fully responsive, standalone order page that demonstrates:
- **Header/Navigation**: Dark navbar with IBrandBiz logo and navigation links
- **Domain Search Bar**: Large, prominent search input with green CTA button
- **Pricing Cards**: Three-column layout (Starter / Professional ★ Recommended / Business)
- **Order Summary**: Sticky sidebar showing cart items and total
- **Footer**: Dark footer with copyright and links

## 🎨 Design Features

### Brand Consistency
- Uses IBrandBiz color palette (green #00CB51, dark gray #231f20)
- Inter font family throughout
- 16px border radius on product cards
- Green gradient header on featured "Professional" plan
- ★ Recommended badge on Professional card

### Responsive Layout
- Bootstrap 3.4.1 grid system
- Desktop: 3-column cards + sidebar summary
- Tablet/Mobile: Stacked cards with summary below
- Sticky order summary on desktop

### Interactive Elements
- "Choose Plan" buttons add items to cart
- Cart displays selected items with remove option
- Continue button enables when cart has items
- Domain search with Enter key support

## 🚀 How to View

### Option 1: Direct File Access
1. Open `index.html` in any modern web browser
2. Everything loads from CDN (Bootstrap, Font Awesome, fonts)

### Option 2: Replit Webview
1. In Replit, navigate to the `ibb-orderform-preview` folder
2. Right-click `index.html` → "Open Preview"
3. The page will load in Replit's webview

### Option 3: Local Server
```bash
cd ibb-orderform-preview
python3 -m http.server 8000
# Visit http://localhost:8000
```

## 📁 File Structure

```
ibb-orderform-preview/
├── index.html              # Main page
├── css/
│   └── styles.css          # All custom styles (port this to WHMCS)
├── js/
│   └── app.js              # Simple cart logic (reference only)
├── img/
│   └── preview.png         # Screenshot for documentation
├── README.md               # This file
├── WHMCS-port-notes.md     # Step-by-step WHMCS integration guide
└── ibrandbiz-orderform-preview.zip
```

## 🎯 What Each Section Demonstrates

### 1. Header/Navbar
- Dark background (#231f20)
- White navigation links with hover opacity
- Dropdown menu for "Store" section
- Right-aligned auth buttons (Sign in / Create account)

### 2. Domain Search
- Large, centered search bar (46px height, 12px radius)
- Green "Search" button
- Secondary "Transfer" button
- Responsive on mobile

### 3. Pricing Cards
- **Starter**: Basic plan, standard styling
- **Professional**: Featured with ★ badge, green border, elevated shadow
- **Business**: Advanced plan, standard styling

Each card includes:
- Dark green header (gradient on featured)
- Large green price display
- Feature list with green checkmarks
- "Choose Plan" CTA button

### 4. Order Summary
- Dark green header
- Live cart updates when plans selected
- Remove item functionality
- Total calculation
- Disabled "Continue" button until cart has items

### 5. Footer
- Dark background matching header
- Copyright with dynamic year
- Privacy/Terms/Contact links

## 🔄 Next Steps

After approval of this preview:

1. **Review** the design in your browser
2. **Check** responsive behavior on mobile/tablet
3. **Verify** it matches your WebServicesPricing page
4. **Read** `WHMCS-port-notes.md` for integration steps
5. **Port** the CSS classes to your WHMCS orderform template

## ⚙️ Technical Constraints

Built to match WHMCS Six environment:
- ✅ Bootstrap 3.4.1 (same as WHMCS)
- ✅ Font Awesome 5.x (compatible)
- ✅ Vanilla JavaScript (no frameworks)
- ✅ No build tools required
- ✅ CSS class hooks ready for WHMCS templates

## 📸 Screenshot

See `img/preview.png` for a visual reference of the complete page.

---

**Ready to port to WHMCS?** See `WHMCS-port-notes.md` for detailed integration instructions.
