# 🚀 Quick Start Guide

## View the Preview NOW

### Option 1: Open in Browser (Easiest)
1. Navigate to `ibb-orderform-preview/` folder
2. Right-click on `index.html`
3. Select "Open Preview" or "Open with Live Server"
4. The order form will load in your browser!

### Option 2: Use the Preview Server
```bash
cd ibb-orderform-preview
node preview-server.js
```
Then open http://localhost:3000 in your browser

### Option 3: Direct File Access
Simply open `index.html` in any browser - all dependencies load from CDN.

---

## 📦 What's Included

```
ibb-orderform-preview/
├── index.html                          ← Main preview page
├── css/styles.css                      ← All styles (copy to WHMCS)
├── js/app.js                           ← Simple cart demo
├── README.md                           ← Full documentation
├── WHMCS-port-notes.md                 ← Integration guide
├── QUICK-START.md                      ← This file
├── preview-server.js                   ← Local server
├── view-preview.sh                     ← Quick launch script
└── ibrandbiz-orderform-preview.tar.gz  ← Complete package

```

---

## ✅ Design Checklist

The preview demonstrates:

- [x] **Header**: Dark navbar with IBrandBiz logo
- [x] **Domain Search**: Large, rounded search bar with green CTA
- [x] **3 Pricing Cards**: Starter / Professional ★ / Business
- [x] **Featured Styling**: Professional plan with badge & green border
- [x] **Order Summary**: Sticky sidebar with live cart updates
- [x] **Responsive**: Mobile-first design, stacks on small screens
- [x] **Brand Colors**: Green #00CB51, Dark Gray #231f20
- [x] **Typography**: Inter font family
- [x] **Icons**: Font Awesome 5.x checkmarks
- [x] **Interactions**: Add to cart, remove items, total calculation

---

## 🎯 Next Steps

1. **Review** the preview in your browser
2. **Test** responsive behavior (resize window)
3. **Verify** it matches WebServicesPricing design
4. **Approve** the design before porting to WHMCS
5. **Follow** `WHMCS-port-notes.md` for integration

---

## 📋 Port to WHMCS

After approval:

1. Copy CSS from `css/styles.css` → WHMCS `style.css`
2. Add class hooks to WHMCS templates (see WHMCS-port-notes.md)
3. Set default orderform to `ibrandbiz_comparison`
4. Clear WHMCS template cache
5. Test at billing.ibrandbiz.com/cart.php

**Detailed instructions:** See `WHMCS-port-notes.md`

---

## 🔧 Technical Details

- **Bootstrap**: 3.4.1 (matches WHMCS Six)
- **Font Awesome**: 5.15.4
- **Font**: Inter from Google Fonts
- **Framework**: Vanilla JS (no React/Vue)
- **Build**: None required - plain HTML/CSS/JS

---

## 📸 Screenshot

To add a screenshot:
1. Open `index.html` in browser
2. Take a screenshot (full page recommended)
3. Save as `img/preview.png` (300x200 or larger)

---

## 💡 Tips

- The "Choose Plan" buttons add items to cart
- Click the X to remove items from cart
- Cart total updates automatically
- Domain search shows alert (demo only)
- All interactions work without backend

---

**Questions?** See README.md for full documentation.
