{* IBrandBiz WHMCS Theme — header.tpl *}
{assign var="brandLogoUrl" value="https://ibrandbiz.com/assets/logo-reverse.png"}
{assign var="siteHomeUrl" value="https://ibrandbiz.com/"}
{assign var="sitePricingUrl" value="https://ibrandbiz.com/web-services-pricing"}

<!DOCTYPE html>
<html lang="{$language}">
<head>
    <meta charset="{$charset}" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>{if $pagetitle}{$pagetitle} - {/if}{$companyname}</title>

    {* WHMCS core styles/scripts *}
    {$headoutput}

    {* IBrandBiz custom overrides *}
    <link rel="stylesheet" href="{$BASE_PATH_CSS}/custom.css" />

    {* Optional: custom font to match Dashboard (example: Inter) *}
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
      body { font-family: "Inter", system-ui, -apple-system, Segoe UI, Roboto, "Helvetica Neue", Arial, "Noto Sans", "Liberation Sans", sans-serif; }
    </style>
</head>

<body class="whmcs-body">

<header class="site-header shadow-sm">
  <div class="container py-2 d-flex align-items-center justify-content-between">
    <a class="brand d-flex align-items-center text-decoration-none" href="{$WEB_ROOT}/">
      <img src="{$brandLogoUrl}" alt="{$companyname}" height="28" class="me-2"/>
      <span class="brand-text fw-semibold text-white d-none d-md-inline">{$companyname}</span>
    </a>

    <div class="header-actions d-flex align-items-center">
      {if $loggedin}
        <a href="{$WEB_ROOT}/clientarea.php" class="btn btn-sm btn-outline-light me-2">Dashboard</a>
        <a href="{$WEB_ROOT}/logout.php" class="btn btn-sm btn-primary">Sign out</a>
      {else}
        <a href="{$WEB_ROOT}/clientarea.php" class="btn btn-sm btn-outline-light me-2">Sign in</a>
        <a href="{$WEB_ROOT}/register.php" class="btn btn-sm btn-primary">Create account</a>
      {/if}
    </div>
  </div>

  {include file="$template/includes/navbar.tpl"}
</header>

{* System alerts (maintenance, announcements, etc.) *}
<div class="container mt-3">
  {$systemAlert|default:''}
</div>

{* Breadcrumbs *}
{if $breadcrumbnav}
  <div class="container">
    {include file="$template/includes/breadcrumb.tpl"}
  </div>
{/if}

{* Begin main content wrapper *}
<main id="main-body" class="py-4">
  <div class="container">
