{*
 * IBrandBiz Comparison Order Form — products.tpl
 * Matches WebServicesPricing.tsx design with WHMCS Smarty logic
 *}

<link rel="stylesheet" type="text/css" href="{$WEB_ROOT}/templates/orderforms/{$carttpl}/style.css" />

<div id="order-premium_comparison">

    <div class="row">
        <div class="col-md-12">

            {if $errormessage}
                <div class="alert alert-danger">
                    <p class="bold">{lang key='orderForm.correctErrors'}:</p>
                    <ul>
                        {$errormessage}
                    </ul>
                </div>
            {/if}

            {if $productGroup}
                <div class="header-lined">
                    <h2>{$productGroup.headline}</h2>
                    {if $productGroup.tagline}
                        <p>{$productGroup.tagline}</p>
                    {/if}
                </div>
            {/if}

        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            
            {if $products}
                <div class="products ibb-products">
                    {foreach $products as $product}
                        <div class="product ibb-card{if $product.isFeatured} featured{/if}" id="product{$product.pid}">
                            
                            {if $product.isFeatured}
                                <span class="ibb-badge" aria-hidden="true">★ Recommended</span>
                            {/if}

                            <div class="product-header ibb-head">
                                <h3 class="product-title ibb-title">
                                    {$product.name}
                                </h3>
                            </div>

                            <div class="product-body">
                                
                                {if $product.pricing.minprice}
                                    <div class="price-container">
                                        <span class="price ibb-price">
                                            {$product.pricing.minprice.price}
                                        </span>
                                        <span class="price-cycle ibb-cycle">
                                            /{$product.pricing.minprice.cycle}
                                        </span>
                                        {if $product.pricing.minprice.setupFee}
                                            <br>
                                            <small class="price-annual">
                                                +{$product.pricing.minprice.setupFee.prefixedPrice} {lang key='orderForm.setupFee'}
                                            </small>
                                        {/if}
                                    </div>
                                {/if}

                                {if $product.description}
                                    <div class="product-desc">
                                        {$product.description}
                                    </div>
                                {/if}

                                {if $product.features}
                                    <ul class="product-features ibb-feats">
                                        {foreach $product.features as $feature}
                                            <li>{$feature}</li>
                                        {/foreach}
                                    </ul>
                                {/if}

                            </div>

                            <div class="product-actions">
                                <a href="{$WEB_ROOT}/cart.php?a=add&pid={$product.pid}" class="btn btn-primary btn-block btn-order ibb-btn" data-testid="button-order-{$product.pid}">
                                    {if $product.qty eq "0"}
                                        {lang key='orderForm.outOfStock'}
                                    {else}
                                        {lang key='orderForm.selectProduct'}
                                    {/if}
                                </a>
                            </div>

                        </div>
                    {/foreach}
                </div>
            {else}
                <div class="alert alert-info text-center" role="alert">
                    {lang key='orderForm.noProductsInCategory'}
                </div>
            {/if}

        </div>
    </div>

    {if $configurableoptions}
        <div class="row">
            <div class="col-md-12">
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h3 class="panel-title">{lang key='orderForm.configureDesiredOptions'}</h3>
                    </div>
                    <div class="panel-body">
                        {foreach $configurableoptions as $configoption}
                            <div class="form-group">
                                <label for="configoption_{$configoption.id}">{$configoption.name}</label>
                                {if $configoption.type eq "select"}
                                    <select name="configoption[{$configoption.id}]" id="configoption_{$configoption.id}" class="form-control">
                                        {foreach $configoption.options as $option}
                                            <option value="{$option.id}"{if $option.selected} selected{/if}>
                                                {$option.name} {$option.price}
                                            </option>
                                        {/foreach}
                                    </select>
                                {/if}
                            </div>
                        {/foreach}
                    </div>
                </div>
            </div>
        </div>
    {/if}

</div>
