{*
 * IBrandBiz Comparison Order Form — configureproduct.tpl
 * Product configuration page with IBrandBiz styling
 *}

<link rel="stylesheet" type="text/css" href="{$WEB_ROOT}/templates/orderforms/{$carttpl}/style.css" />

<div id="order-premium_comparison" class="ibb-config">

    <div class="row">
        <div class="col-md-8">

            <div class="header-lined">
                <h2>{$productinfo.groupname} - {$productinfo.name}</h2>
                {if $productinfo.description}
                    <p>{$productinfo.description}</p>
                {/if}
            </div>

            {if $errormessage}
                <div class="alert alert-danger" role="alert">
                    <p class="bold">{lang key='orderForm.correctErrors'}:</p>
                    <ul>
                        {$errormessage}
                    </ul>
                </div>
            {/if}

            <form method="post" action="{$smarty.server.PHP_SELF}?a=add&pid={$productinfo.pid}">

                {if $pricing.type eq "free"}
                    <div class="alert alert-info">
                        {lang key='orderForm.free'}
                    </div>
                {else}
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <h3 class="panel-title">{lang key='orderForm.billingCycle'}</h3>
                        </div>
                        <div class="panel-body">
                            <div class="row">
                                {foreach $pricing.cycles as $cycle => $price}
                                    <div class="col-sm-6 col-md-4">
                                        <label class="radio-inline">
                                            <input type="radio" name="billingcycle" value="{$cycle}"{if $selectedcycle eq $cycle} checked{/if} data-testid="radio-cycle-{$cycle}">
                                            <strong>{$price.cycleText}</strong> - {$price.price}
                                            {if $price.setupFee}
                                                <br><small>+ {$price.setupFee.prefixedPrice} {lang key='orderForm.setupFee'}</small>
                                            {/if}
                                        </label>
                                    </div>
                                {/foreach}
                            </div>
                        </div>
                    </div>
                {/if}

                {if $configurableoptions}
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <h3 class="panel-title">{lang key='orderForm.configureProduct'}</h3>
                        </div>
                        <div class="panel-body">
                            {foreach $configurableoptions as $option}
                                <div class="form-group">
                                    <label for="configoption_{$option.id}">
                                        {$option.name}
                                        {if $option.description}
                                            <small class="text-muted">({$option.description})</small>
                                        {/if}
                                    </label>
                                    
                                    {if $option.type eq 1}
                                        <select name="configoption[{$option.id}]" id="configoption_{$option.id}" class="form-control" data-testid="select-config-{$option.id}">
                                            {foreach $option.options as $optval}
                                                <option value="{$optval.id}"{if $optval.selected} selected{/if}>
                                                    {$optval.name} {if $optval.price neq "0.00"}+{$optval.price}{/if}
                                                </option>
                                            {/foreach}
                                        </select>
                                    {elseif $option.type eq 2}
                                        {foreach $option.options as $optval}
                                            <label class="radio-inline">
                                                <input type="radio" name="configoption[{$option.id}]" value="{$optval.id}"{if $optval.selected} checked{/if} data-testid="radio-config-{$option.id}-{$optval.id}">
                                                {$optval.name} {if $optval.price neq "0.00"}+{$optval.price}{/if}
                                            </label>
                                        {/foreach}
                                    {elseif $option.type eq 3}
                                        {foreach $option.options as $optval}
                                            <label class="checkbox-inline">
                                                <input type="checkbox" name="configoption[{$option.id}][]" value="{$optval.id}"{if $optval.selected} checked{/if} data-testid="checkbox-config-{$option.id}-{$optval.id}">
                                                {$optval.name} {if $optval.price neq "0.00"}+{$optval.price}{/if}
                                            </label>
                                        {/foreach}
                                    {elseif $option.type eq 4}
                                        <input type="text" name="configoption[{$option.id}]" value="{$option.selectedvalue}" class="form-control" data-testid="input-config-{$option.id}">
                                        {if $option.selectedqty}
                                            <small class="text-muted">{$option.selectedqty} x {$option.selectedprice}</small>
                                        {/if}
                                    {/if}
                                </div>
                            {/foreach}
                        </div>
                    </div>
                {/if}

                {if $addons}
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <h3 class="panel-title">{lang key='orderForm.addons'}</h3>
                        </div>
                        <div class="panel-body">
                            {foreach $addons as $addon}
                                <label class="checkbox-inline">
                                    <input type="checkbox" name="addons[]" value="{$addon.id}"{if $addon.selected} checked{/if} data-testid="checkbox-addon-{$addon.id}">
                                    {$addon.name} - {$addon.price}
                                </label>
                                {if $addon.description}
                                    <br><small class="text-muted">{$addon.description}</small>
                                {/if}
                            {/foreach}
                        </div>
                    </div>
                {/if}

                <div class="text-right">
                    <button type="submit" class="btn btn-lg btn-success ibb-btn" data-testid="button-add-to-cart">
                        <i class="fas fa-shopping-cart"></i> {lang key='addtocart'}
                    </button>
                </div>

            </form>

        </div>

        <div class="col-md-4">
            <div id="orderSummary" class="panel panel-default ibb-summary">
                <div class="panel-heading">
                    <h3 class="panel-title">{lang key='orderSummary'}</h3>
                </div>
                <div class="panel-body">
                    
                    <div class="summary-container">
                        <div class="row">
                            <div class="col-xs-6"><strong>{$productinfo.name}</strong></div>
                            <div class="col-xs-6 text-right" id="product-price">
                                {if $pricing.type eq "free"}
                                    {lang key='orderForm.free'}
                                {else}
                                    {$pricing.cycles[$selectedcycle].price}
                                {/if}
                            </div>
                        </div>
                        
                        {if $pricing.cycles[$selectedcycle].setupFee}
                            <div class="row">
                                <div class="col-xs-6">{lang key='orderForm.setupFee'}:</div>
                                <div class="col-xs-6 text-right">{$pricing.cycles[$selectedcycle].setupFee.prefixedPrice}</div>
                            </div>
                        {/if}

                        <hr>

                        <div class="row total-row">
                            <div class="col-xs-6"><strong>{lang key='orderForm.total'}:</strong></div>
                            <div class="col-xs-6 text-right" id="total-price">
                                <strong>{$pricing.cycles[$selectedcycle].totalPrice}</strong>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>

</div>
