// IBrandBiz Order Form - Simple Cart Management

let cartItems = [];

// Set current year in footer
document.getElementById('currentYear').textContent = new Date().getFullYear();

// Handle "Choose Plan" clicks
document.querySelectorAll('.btn-choose').forEach(button => {
  button.addEventListener('click', function() {
    const plan = this.getAttribute('data-plan');
    const price = parseFloat(this.getAttribute('data-price'));
    
    // Check if plan already in cart
    const existingIndex = cartItems.findIndex(item => item.plan === plan);
    
    if (existingIndex === -1) {
      // Add to cart
      cartItems.push({ plan, price });
      updateCart();
      
      // Visual feedback
      this.innerHTML = '<i class="fas fa-check"></i> Added!';
      this.style.backgroundColor = '#00b047';
      
      setTimeout(() => {
        this.innerHTML = 'Choose Plan';
        this.style.backgroundColor = '';
      }, 1500);
    } else {
      // Already in cart - show message
      this.innerHTML = '<i class="fas fa-info-circle"></i> Already Added';
      setTimeout(() => {
        this.innerHTML = 'Choose Plan';
      }, 1500);
    }
  });
});

// Update cart display
function updateCart() {
  const summaryItemsEl = document.getElementById('summaryItems');
  const totalPriceEl = document.getElementById('totalPrice');
  const continueBtn = document.getElementById('continueBtn');
  
  if (cartItems.length === 0) {
    summaryItemsEl.innerHTML = '<p class="empty-cart">Your cart is empty. Choose a plan to get started!</p>';
    totalPriceEl.textContent = '$0.00';
    continueBtn.disabled = true;
  } else {
    let itemsHTML = '';
    let total = 0;
    
    cartItems.forEach((item, index) => {
      total += item.price;
      itemsHTML += `
        <div class="cart-item">
          <span class="cart-item-name">${item.plan} Hosting</span>
          <div>
            <span class="cart-item-price">$${item.price.toFixed(2)}</span>
            <button class="cart-item-remove" onclick="removeFromCart(${index})">
              <i class="fas fa-times"></i>
            </button>
          </div>
        </div>
      `;
    });
    
    summaryItemsEl.innerHTML = itemsHTML;
    totalPriceEl.textContent = '$' + total.toFixed(2);
    continueBtn.disabled = false;
  }
}

// Remove item from cart
function removeFromCart(index) {
  cartItems.splice(index, 1);
  updateCart();
}

// Continue button handler
document.getElementById('continueBtn').addEventListener('click', function() {
  if (cartItems.length > 0) {
    alert('In a real implementation, this would proceed to checkout.\n\nYour cart:\n' + 
          cartItems.map(item => `${item.plan}: $${item.price}`).join('\n'));
  }
});

// Domain search handler
document.querySelector('.btn-search').addEventListener('click', function() {
  const domain = document.getElementById('domainSearchInput').value.trim();
  if (domain) {
    alert('In a real implementation, this would search for: ' + domain);
  } else {
    alert('Please enter a domain name to search.');
  }
});

// Enter key support for domain search
document.getElementById('domainSearchInput').addEventListener('keypress', function(e) {
  if (e.key === 'Enter') {
    document.querySelector('.btn-search').click();
  }
});

console.log('IBrandBiz Order Form Preview - Ready');
