{include file="orderforms/{$carttpl}/includes/head.tpl" pageTitle=$LANG.cartconfigreview}

<div class="container">
  
  <div class="page-header-section">
    <h1 class="page-title">{$LANG.configuredesired}</h1>
  </div>

  {if $errormessage}
    <div class="alert alert-danger">
      <strong>Error:</strong> {$errormessage}
    </div>
  {/if}

  <div class="row">
    <div class="col-md-8">
      
      <form method="post" action="{$WEB_ROOT}/cart.php?a=confproduct" id="frmConfigureProduct">
        <input type="hidden" name="configure" value="true">
        <input type="hidden" name="i" value="{$i}">
        
        <!-- Product Info -->
        <div class="product-configuration">
          <h3>{$productinfo.groupname} - {$productinfo.name}</h3>
          {if $productinfo.description}
            <p class="text-muted">{$productinfo.description}</p>
          {/if}
        </div>

        <!-- Billing Cycle -->
        {if $pricing.type eq "recurring"}
          <div class="form-group">
            <label class="control-label">{$LANG.cartchoosecycle}</label>
            <select name="billingcycle" class="form-control" onchange="recalctotals()">
              {foreach $pricing.cycles as $cycle => $price}
                <option value="{$cycle}" {if $billingcycle eq $cycle}selected{/if}>
                  {$price.cycleText} - {$price.price}
                </option>
              {/foreach}
            </select>
          </div>
        {/if}

        <!-- Configurable Options -->
        {if $configurableoptions}
          <div class="configurable-options">
            <h4>{$LANG.orderconfigpackage}</h4>
            {foreach $configurableoptions as $option}
              <div class="form-group">
                <label class="control-label">{$option.optionname}</label>
                {if $option.optiontype == 1}
                  <select name="configoption[{$option.id}]" class="form-control" onchange="recalctotals()">
                    {foreach $option.options as $opt}
                      <option value="{$opt.id}" {if $opt.selected}selected{/if}>
                        {$opt.name} {if $opt.price}{$opt.price}{/if}
                      </option>
                    {/foreach}
                  </select>
                {elseif $option.optiontype == 2}
                  {foreach $option.options as $opt}
                    <div class="radio">
                      <label>
                        <input type="radio" name="configoption[{$option.id}]" value="{$opt.id}" {if $opt.selected}checked{/if} onchange="recalctotals()">
                        {$opt.name} {if $opt.price}{$opt.price}{/if}
                      </label>
                    </div>
                  {/foreach}
                {elseif $option.optiontype == 3}
                  {foreach $option.options as $opt}
                    <div class="checkbox">
                      <label>
                        <input type="checkbox" name="configoption[{$option.id}][]" value="{$opt.id}" {if $opt.selected}checked{/if} onchange="recalctotals()">
                        {$opt.name} {if $opt.price}{$opt.price}{/if}
                      </label>
                    </div>
                  {/foreach}
                {elseif $option.optiontype == 4}
                  <input type="text" name="configoption[{$option.id}]" class="form-control" value="{$option.value}" onchange="recalctotals()">
                {/if}
              </div>
            {/foreach}
          </div>
        {/if}

        <!-- Custom Fields -->
        {if $customfields}
          <div class="custom-fields">
            <h4>{$LANG.orderadditionalrequired}</h4>
            {foreach $customfields as $field}
              <div class="form-group">
                <label class="control-label">{$field.name} {if $field.required}<span class="text-danger">*</span>{/if}</label>
                {if $field.type == "text"}
                  <input type="text" name="customfield[{$field.id}]" class="form-control" value="{$field.value}" {if $field.required}required{/if}>
                {elseif $field.type == "password"}
                  <input type="password" name="customfield[{$field.id}]" class="form-control" {if $field.required}required{/if}>
                {elseif $field.type == "dropdown"}
                  <select name="customfield[{$field.id}]" class="form-control" {if $field.required}required{/if}>
                    {foreach $field.options as $opt}
                      <option value="{$opt}">{$opt}</option>
                    {/foreach}
                  </select>
                {elseif $field.type == "textarea"}
                  <textarea name="customfield[{$field.id}]" class="form-control" rows="3" {if $field.required}required{/if}>{$field.value}</textarea>
                {/if}
                {if $field.description}
                  <small class="text-muted">{$field.description}</small>
                {/if}
              </div>
            {/foreach}
          </div>
        {/if}

        <!-- Action Buttons -->
        <div class="form-actions">
          <button type="submit" class="btn btn-primary btn-lg">
            {$LANG.continue} <i class="fas fa-arrow-right"></i>
          </button>
          <a href="{$WEB_ROOT}/cart.php?a=view" class="btn btn-default">
            {$LANG.cancel}
          </a>
        </div>

      </form>

    </div>

    <!-- Product Summary Sidebar -->
    <div class="col-md-4">
      <div class="order-summary">
        <h3 class="order-summary-header">Product Summary</h3>
        <div id="producttotal"></div>
      </div>
    </div>
  </div>

</div>

<script>
function recalctotals() {
  // WHMCS function to recalculate product totals
  jQuery.post(
    "{$WEB_ROOT}/cart.php",
    jQuery("#frmConfigureProduct").serialize() + "&ajax=1&a=confproduct&calctotal=true",
    function(data) {
      jQuery("#producttotal").html(data);
    }
  );
}
// Initial calculation
recalctotals();
</script>

{include file="orderforms/{$carttpl}/includes/footer.tpl"}
